package org.msh.tb.indicators;

import org.jboss.seam.annotations.Name;
import org.jboss.seam.international.Messages;
import org.msh.tb.entities.enums.CaseClassification;
import org.msh.tb.entities.enums.MessageKey;

import javax.faces.model.SelectItem;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by rmemoria on 22/7/17.
 */
@Name("filterOptions")
public class FilterOptions {

    private List<SelectItem> classifications;

    /**
     * Create a list of options based on the enums
     *
     * @param enums
     * @return
     */
    private List<SelectItem> createEnumOptions(Enum[] enums) {
        List<SelectItem> lst = new ArrayList<SelectItem>(enums.length + 1);

        lst.add(new SelectItem("", "-"));
        for (Enum it : enums) {
            String label = it instanceof MessageKey ?
                    Messages.instance().get(((MessageKey) it).getMessageKey()) :
                    Messages.instance().get(it.getClass().getSimpleName() + '.' + it.toString());

            lst.add(new SelectItem(it, label));
        }
        return lst;
    }

    /**
     * Return a list of classification options
     *
     * @return
     */
    public List<SelectItem> getClassifications() {
        if (classifications == null) {
            classifications = createEnumOptions(CaseClassification.values());
        }
        return classifications;
    }

    public void setClassifications(List<SelectItem> classifications) {
        this.classifications = classifications;
    }
}
